<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;

Route::get('/', function () {
    user_logs();
    return view('welcome');
});


Auth::routes();

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

Route::group(['middleware' => ['auth']], function () {

    Route::resource('roles', App\Http\Controllers\RoleController::class);

    /**
     * 
     * Users Routes
     * 
     */
    Route::resource('users', App\Http\Controllers\UserController::class);
    Route::get('/user/{roleId}', [App\Http\Controllers\UserController::class, 'userList'])->name('users.userlist');
 

    /**
     * 
     * @return all user's DSP with all countries
     * User can we connect with single DSP in multiple countries.
     * 
     */
     Route::resource('userdsp', App\Http\Controllers\UsersDSPController::class);
     Route::post('/userdsp/status', [App\Http\Controllers\UsersDSPController::class, 'userDspStatus'])->name('userdsp.userDspStatus');


    /**
     * 
     *UPC Routes
     * 
     */
    Route::resource('upcs', App\Http\Controllers\UPCSController::class);
    Route::post('/upcs/manual/upload', [App\Http\Controllers\UPCSController::class, 'manualUpload'])->name('upcs.manual.upload');



    /**
     * 
     * Genre routes
     * 
     */
    Route::resource('genre', App\Http\Controllers\GenreController::class);
    Route::post('/genre/status/update', [App\Http\Controllers\GenreController::class, 'statusUpdate'])->name('genre.status.update');


    /**
     * 
     * Sub Genre routes
     * 
     */
    Route::resource('subgenre', App\Http\Controllers\SubGenreController::class);
    Route::post('/subgenre/status/update', [App\Http\Controllers\SubGenreController::class, 'statusUpdate'])->name('subgenre.status.update');



    /**
     * 
     * Country routes
     * 
     */
    Route::resource('country', App\Http\Controllers\CountryController::class);
    Route::post('/country/status/update', [App\Http\Controllers\CountryController::class, 'statusUpdate'])->name('country.status.update');




    /**
     * 
     * DSP routes
     * 
     */
    Route::resource('dsp', App\Http\Controllers\DSPController::class);
    Route::post('/dsp/status/update', [App\Http\Controllers\DSPController::class, 'statusUpdate'])->name('dsp.status.update');



    /**
     * 
     * Logs routes
     * 
     */
    Route::resource('logs', App\Http\Controllers\LogsController::class);




    /**
     * 
     * Content routes
     * 
     */
    Route::resource('contents', App\Http\Controllers\ContentsController::class);


    /**
     * 
     * Release routes
     * 
     */
     Route::resource('release', App\Http\Controllers\ReleaseController::class);

     Route::post('/release/subgenre', [App\Http\Controllers\ReleaseController::class, 'getReleaseSubGenre'])->name('release.subgenre');

     Route::post('/release/track/save/{id}', [App\Http\Controllers\ReleaseController::class, 'releaseTrackUpdate'])->name('release.track.save');

     Route::post('/release/terriory/save/{id}', [App\Http\Controllers\ReleaseController::class, 'releaseTerrioryUpdate'])->name('release.terriory.save');

     Route::post('/release/delivery/save/{id}', [App\Http\Controllers\ReleaseController::class, 'releaseDeliveryUpdate'])->name('release.delivery.save');


     Route::post('/release/finish/save/{id}', [App\Http\Controllers\ReleaseController::class, 'releaseFinishUpdate'])->name('release.finish.save');


    /**
     * 
     * Artist Routes
     * 
     */
     Route::resource('artists', App\Http\Controllers\ArtistController::class);
});
